/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CopyMemoryWithExpiry;
import net.minecraft.world.entity.ai.behavior.CrossbowAttack;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StartCelebratingIfTargetDead;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.monster.piglin.RememberIfHoglinWasKilled;
import net.minecraft.world.entity.monster.piglin.StartAdmiringItemIfSeen;
import net.minecraft.world.entity.monster.piglin.StartHuntingHoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import tallestred.piglinproliferation.PPActivities;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.PPLootTables;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;
import tallestred.piglinproliferation.common.entities.ai.behaviors.BowAttack;
import tallestred.piglinproliferation.common.entities.ai.behaviors.MoveAroundPiglins;
import tallestred.piglinproliferation.common.entities.ai.behaviors.ShootTippedArrow;
import tallestred.piglinproliferation.common.entities.ai.behaviors.StopHoldingItemIfNoLongerAdmiringAlchemist;
import tallestred.piglinproliferation.common.entities.ai.behaviors.SwimOnlyOutOfLava;
import tallestred.piglinproliferation.common.entities.ai.behaviors.ThrowPotionAtSelfTask;
import tallestred.piglinproliferation.common.entities.ai.behaviors.ThrowPotionAtTargetTask;

public class PiglinAlchemistAi
extends PiglinAi {
    private static final UniformInt RIDE_START_INTERVAL = TimeUtil.m_145020_((int)10, (int)40);
    private static final UniformInt RIDE_DURATION = TimeUtil.m_145020_((int)10, (int)30);
    private static final UniformInt AVOID_ZOMBIFIED_DURATION = TimeUtil.m_145020_((int)5, (int)7);
    private static final UniformInt BABY_AVOID_NEMESIS_DURATION = TimeUtil.m_145020_((int)5, (int)7);
    private static final Method hoglinRiding = ObfuscationReflectionHelper.findMethod(PiglinAi.class, (String)"m_34973_", (Class[])new Class[]{Brain.class});
    private static final Method retreatActivity = ObfuscationReflectionHelper.findMethod(PiglinAi.class, (String)"m_34958_", (Class[])new Class[]{Brain.class});
    private static final Method celebrateActivity = ObfuscationReflectionHelper.findMethod(PiglinAi.class, (String)"m_34920_", (Class[])new Class[]{Brain.class});
    private static final Method admireItem = ObfuscationReflectionHelper.findMethod(PiglinAi.class, (String)"m_34940_", (Class[])new Class[]{Brain.class});

    public static Brain<?> makeBrain(PiglinAlchemist piglin, Brain<PiglinAlchemist> brain) {
        try {
            PiglinAlchemistAi.initIdleActivity(brain);
            PiglinAlchemistAi.initCoreActivity(brain, piglin);
            admireItem.invoke(PiglinAi.class, brain);
            PiglinAlchemistAi.initFightActivity(piglin, brain);
            celebrateActivity.invoke(PiglinAi.class, brain);
            retreatActivity.invoke(PiglinAi.class, brain);
            hoglinRiding.invoke(PiglinAi.class, brain);
            PiglinAlchemistAi.initThrowPotionActivity(brain, piglin);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            new RuntimeException("Reflection failed, please report to the Piglin-Proliferation github");
        }
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initFightActivity(PiglinAlchemist piglin, Brain<PiglinAlchemist> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)new StopAttackingIfTargetInvalid(target -> !PiglinAlchemistAi.isNearestValidAttackTarget(piglin, target)), (Object)new RunIf(PiglinAlchemistAi::hasCrossbow, (Behavior)new BackUpIfTooClose(5, 0.75f)), (Object)new SetWalkTargetFromAttackTargetIfTargetOutOfReach(1.0f), (Object)new MeleeAttack(20), (Object)new CrossbowAttack(), (Object)new RememberIfHoglinWasKilled(), new BowAttack((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 1.5, 15.0f, 20), (Object)new EraseMemoryIf(PiglinAlchemistAi::isNearZombified, MemoryModuleType.f_26372_)), MemoryModuleType.f_26372_);
    }

    private static void initCoreActivity(Brain<PiglinAlchemist> brain, PiglinAlchemist alchmeist) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new InteractWithDoor(), (Object)((Object)new SwimOnlyOutOfLava(0.8f)), PiglinAlchemistAi.avoidZombified(), PiglinAlchemistAi.generatePotionAi(alchmeist), new StopHoldingItemIfNoLongerAdmiringAlchemist(), (Object)((Object)new ShootTippedArrow(1.5, 15.0f, 20, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)Potions.f_43581_), piglin -> piglin.m_6084_() && piglin.m_21223_() < piglin.m_21233_())), (Object)new StartAdmiringItemIfSeen(120), (Object)new StartCelebratingIfTargetDead(300, PiglinAlchemistAi::wantsToDance), (Object)new StopBeingAngryIfTargetDead()));
    }

    private static void initIdleActivity(Brain<PiglinAlchemist> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)new SetEntityLookTarget(PiglinAi::m_34883_, 14.0f), (Object)new StartAttacking(AbstractPiglin::m_34667_, PiglinAlchemistAi::findNearestValidAttackTarget), (Object)new RunIf(PiglinAlchemist::m_7121_, (Behavior)new StartHuntingHoglin()), PiglinAlchemistAi.avoidRepellent(), PiglinAlchemistAi.babySometimesRideBabyHoglin(), PiglinAlchemistAi.createIdleLookBehaviors(), PiglinAlchemistAi.createIdleMovementBehaviors(), (Object)new SetLookAndInteract(EntityType.f_20532_, 4)));
    }

    private static void initThrowPotionActivity(Brain<PiglinAlchemist> brain, PiglinAlchemist piglin) {
        brain.m_21895_((Activity)PPActivities.THROW_POTION_ACTIVITY.get(), 10, ImmutableList.of((Object)((Object)new ShootTippedArrow(1.5, 15.0f, 20, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)Potions.f_43581_), piglin2 -> piglin2.m_6084_() && piglin2.m_21223_() < piglin2.m_21233_())), PiglinAlchemistAi.generatePotionAi(piglin)), (MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get());
    }

    private static RunSometimes<Piglin> babySometimesRideBabyHoglin() {
        return new RunSometimes((Behavior)new CopyMemoryWithExpiry(Piglin::m_6162_, MemoryModuleType.f_26344_, MemoryModuleType.f_26376_, RIDE_DURATION), RIDE_START_INTERVAL);
    }

    private static RunOne<Piglin> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new SetEntityLookTarget(EntityType.f_20532_, 8.0f), (Object)1), (Object)Pair.of((Object)new SetEntityLookTarget(EntityType.f_20511_, 8.0f), (Object)1), (Object)Pair.of((Object)new SetEntityLookTarget(8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<Piglin> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)((Object)new MoveAroundPiglins(0.8f)), (Object)2), (Object)Pair.of((Object)new RandomStroll(0.6f), (Object)2), (Object)Pair.of((Object)InteractWith.m_23260_((EntityType)EntityType.f_20511_, (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)new RunIf(PiglinAlchemistAi::doesntSeeAnyPlayerHoldingLovedItem, (Behavior)new SetWalkTargetFromLookTarget(0.6f, 3)), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<PiglinAlchemist> generatePotionAi(PiglinAlchemist piglinAlchemist) {
        return new RunOne((List)ImmutableList.of((Object)Pair.of(new ThrowPotionAtTargetTask(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43610_), alchemist -> alchemist.m_6084_(), piglin -> piglin.m_6084_() && piglin.m_6060_()), (Object)1), (Object)Pair.of(new ThrowPotionAtTargetTask(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43589_), alchemist -> alchemist.m_6084_(), piglin -> {
            List list = piglinAlchemist.f_19853_.m_45976_(AbstractPiglin.class, piglinAlchemist.m_20191_().m_82377_(10.0, 3.0, 10.0));
            if (!list.isEmpty()) {
                for (AbstractPiglin piglin1 : list) {
                    if (piglin1.m_5448_() == null && piglinAlchemist.m_5448_() == null) continue;
                    return list.size() > 2 && piglin.m_6084_() && piglin.m_21223_() < piglin.m_21233_();
                }
            }
            return piglin.m_6084_() && piglin.m_21223_() < piglin.m_21233_();
        }), (Object)1), (Object)Pair.of(new ThrowPotionAtTargetTask(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43581_), alchemist -> alchemist.m_6084_(), piglin -> {
            List list = piglinAlchemist.f_19853_.m_45976_(AbstractPiglin.class, piglinAlchemist.m_20191_().m_82377_(10.0, 3.0, 10.0));
            if (!list.isEmpty()) {
                for (AbstractPiglin piglin1 : list) {
                    if (piglin1.m_5448_() == null && piglinAlchemist.m_5448_() == null) continue;
                    return piglin.m_6084_() && piglin.m_21223_() < piglin.m_21233_() && !piglinAlchemist.beltInventory.stream().anyMatch(itemStack -> PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43589_) && list.size() > 2;
                }
            }
            return piglin.m_6084_() && piglin.m_21223_() < piglin.m_21233_();
        }), (Object)1), (Object)Pair.of((Object)new ThrowPotionAtTargetTask<PiglinAlchemist>(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43592_), alchemist -> alchemist.m_6084_(), piglin -> piglin.m_6084_() && piglin.m_5448_() != null && piglin.m_21223_() < piglin.m_21233_() / 2.0f && !piglin.m_21093_(itemStack -> {
            Item itemInStack = itemStack.m_41720_();
            return itemInStack instanceof ProjectileWeaponItem;
        })){

            @Override
            protected void start(ServerLevel level, PiglinAlchemist alchemist, long gameTime) {
                super.start(level, alchemist, gameTime);
                Mob piglinsCalled = (Mob)alchemist.m_6274_().m_21952_((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()).orElseGet(null);
                piglinsCalled.m_21573_().m_5624_((Entity)alchemist, 1.0);
            }

            @Override
            protected void tick(ServerLevel level, PiglinAlchemist alchemist, long gameTime) {
                super.tick(level, alchemist, gameTime);
                Mob piglinsCalled = (Mob)alchemist.m_6274_().m_21952_((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()).orElseGet(null);
                piglinsCalled.m_21573_().m_5624_((Entity)alchemist, 1.0);
            }
        }, (Object)1), (Object)Pair.of(new ThrowPotionAtTargetTask(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43610_), alchemist -> alchemist.m_6084_(), piglin -> piglin.m_6084_() && piglin.m_6060_()), (Object)1), (Object)Pair.of(new ThrowPotionAtSelfTask(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43589_), alchemist -> alchemist.m_6084_() && alchemist.m_21223_() < alchemist.m_21233_()), (Object)1), (Object)Pair.of(new ThrowPotionAtSelfTask(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43610_), alchemist -> alchemist.m_6084_() && alchemist.m_6060_()), (Object)1), (Object)Pair.of(new ThrowPotionAtSelfTask(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43581_), alchemist -> alchemist.m_6084_() && alchemist.m_21223_() < alchemist.m_21233_() && !alchemist.beltInventory.stream().anyMatch(itemStack -> PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43589_)), (Object)2)));
    }

    private static boolean doesntSeeAnyPlayerHoldingLovedItem(LivingEntity p_34983_) {
        return !PiglinAlchemistAi.seesPlayerHoldingLovedItem(p_34983_);
    }

    private static boolean seesPlayerHoldingLovedItem(LivingEntity p_34972_) {
        return p_34972_.m_6274_().m_21874_(MemoryModuleType.f_26354_);
    }

    private static CopyMemoryWithExpiry<Piglin, LivingEntity> babyAvoidNemesis() {
        return new CopyMemoryWithExpiry(Piglin::m_6162_, MemoryModuleType.f_26333_, MemoryModuleType.f_26383_, BABY_AVOID_NEMESIS_DURATION);
    }

    private static CopyMemoryWithExpiry<Piglin, LivingEntity> avoidZombified() {
        return new CopyMemoryWithExpiry(PiglinAlchemistAi::isNearZombified, MemoryModuleType.f_26351_, MemoryModuleType.f_26383_, AVOID_ZOMBIFIED_DURATION);
    }

    private static SetWalkTargetAwayFrom<BlockPos> avoidRepellent() {
        return SetWalkTargetAwayFrom.m_24012_((MemoryModuleType)MemoryModuleType.f_26356_, (float)1.0f, (int)8, (boolean)false);
    }

    private static boolean wantsToDance(LivingEntity p_34811_, LivingEntity p_34812_) {
        if (p_34812_.m_6095_() != EntityType.f_20456_) {
            return false;
        }
        return RandomSource.m_216335_((long)p_34811_.f_19853_.m_46467_()).m_188501_() < 0.1f;
    }

    public static void stopHoldingOffHandItem(Piglin piglin, boolean barter) {
        ItemStack itemstack = piglin.m_21120_(InteractionHand.OFF_HAND);
        piglin.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        if (piglin.m_34667_()) {
            boolean flag1;
            boolean flag = itemstack.isPiglinCurrency();
            if (barter && flag) {
                PiglinAlchemistAi.throwItems(piglin, PiglinAlchemistAi.getBarterResponseItems(piglin));
            } else if (!flag && !(flag1 = piglin.m_21540_(itemstack))) {
                PiglinAlchemistAi.putInInventory(piglin, itemstack);
            }
        } else {
            boolean flag2 = piglin.m_21540_(itemstack);
            if (!flag2) {
                ItemStack itemstack1 = piglin.m_21205_();
                if (PiglinAlchemistAi.m_149965_((ItemStack)itemstack1)) {
                    PiglinAlchemistAi.putInInventory(piglin, itemstack1);
                } else {
                    PiglinAlchemistAi.throwItems(piglin, Collections.singletonList(itemstack1));
                }
                piglin.m_8061_(EquipmentSlot.MAINHAND, itemstack);
                piglin.m_21508_(EquipmentSlot.MAINHAND);
                piglin.m_21530_();
            }
        }
    }

    private static void putInInventory(Piglin piglin, ItemStack item) {
        ItemStack itemstack = piglin.m_35311_().m_19173_(item);
        PiglinAlchemistAi.throwItemsTowardRandomPos(piglin, Collections.singletonList(itemstack));
    }

    private static void throwItems(Piglin p_34861_, List<ItemStack> p_34862_) {
        Optional optional = p_34861_.m_6274_().m_21952_(MemoryModuleType.f_26368_);
        if (optional.isPresent()) {
            PiglinAlchemistAi.throwItemsTowardPlayer(p_34861_, (Player)optional.get(), p_34862_);
        } else {
            PiglinAlchemistAi.throwItemsTowardRandomPos(p_34861_, p_34862_);
        }
    }

    private static void throwItemsTowardRandomPos(Piglin p_34913_, List<ItemStack> p_34914_) {
        PiglinAlchemistAi.throwItemsTowardPos(p_34913_, p_34914_, PiglinAlchemistAi.getRandomNearbyPos(p_34913_));
    }

    private static void throwItemsTowardPlayer(Piglin p_34851_, Player p_34852_, List<ItemStack> p_34853_) {
        PiglinAlchemistAi.throwItemsTowardPos(p_34851_, p_34853_, p_34852_.m_20182_());
    }

    private static void throwItemsTowardPos(Piglin p_34864_, List<ItemStack> p_34865_, Vec3 p_34866_) {
        if (!p_34865_.isEmpty()) {
            p_34864_.m_6674_(InteractionHand.OFF_HAND);
            for (ItemStack itemstack : p_34865_) {
                BehaviorUtils.m_22613_((LivingEntity)p_34864_, (ItemStack)itemstack, (Vec3)p_34866_.m_82520_(0.0, 1.0, 0.0));
            }
        }
    }

    private static List<ItemStack> getBarterResponseItems(Piglin p_34997_) {
        LootTable loottable = p_34997_.f_19853_.m_7654_().m_129898_().m_79217_(PPLootTables.ALCHEMIST_BARTER);
        ObjectArrayList list = loottable.m_230922_(new LootContext.Builder((ServerLevel)p_34997_.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)p_34997_).m_230911_(p_34997_.f_19853_.f_46441_).m_78975_(LootContextParamSets.f_81417_));
        return list;
    }

    private static boolean hasCrossbow(LivingEntity entity) {
        return entity.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
    }

    private static boolean isNearestValidAttackTarget(Piglin piglin, LivingEntity p_34902_) {
        return PiglinAlchemistAi.findNearestValidAttackTarget(piglin).filter(p_34887_ -> p_34887_ == p_34902_).isPresent();
    }

    private static boolean isNearZombified(Piglin piglin) {
        Brain brain = piglin.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_26351_)) {
            LivingEntity livingentity = (LivingEntity)brain.m_21952_(MemoryModuleType.f_26351_).get();
            return piglin.m_19950_((Entity)livingentity, 6.0);
        }
        return false;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Piglin piglin) {
        Optional optional3;
        Brain brain = piglin.m_6274_();
        if (PiglinAlchemistAi.isNearZombified(piglin)) {
            return Optional.empty();
        }
        Optional optional = BehaviorUtils.m_22610_((LivingEntity)piglin, (MemoryModuleType)MemoryModuleType.f_26334_);
        if (optional.isPresent() && Sensor.m_182377_((LivingEntity)piglin, (LivingEntity)((LivingEntity)optional.get()))) {
            return optional;
        }
        if (brain.m_21874_(MemoryModuleType.f_26335_) && (optional3 = brain.m_21952_(MemoryModuleType.f_148206_)).isPresent()) {
            return optional3;
        }
        optional3 = brain.m_21952_(MemoryModuleType.f_26333_);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional optional2 = brain.m_21952_(MemoryModuleType.f_26345_);
        return optional2.isPresent() && Sensor.m_148312_((LivingEntity)piglin, (LivingEntity)((LivingEntity)optional2.get())) ? optional2 : Optional.empty();
    }

    private static Vec3 getRandomNearbyPos(Piglin piglin) {
        Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)piglin, (int)4, (int)2);
        return vec3 == null ? piglin.m_20182_() : vec3;
    }

    private static boolean isBabyRidingBaby(Piglin piglin) {
        if (!piglin.m_6162_()) {
            return false;
        }
        Entity entity = piglin.m_20202_();
        return entity instanceof Piglin && ((Piglin)entity).m_6162_() || entity instanceof Hoglin && ((Hoglin)entity).m_6162_();
    }

    public static Optional<SoundEvent> getAlchemistSoundForCurrentActivity(PiglinAlchemist piglin) {
        return piglin.m_6274_().m_21968_().map(activity -> PiglinAlchemistAi.getAlchemistSoundForActivity(piglin, activity));
    }

    private static SoundEvent getAlchemistSoundForActivity(Piglin piglin, Activity activity) {
        if (activity == Activity.f_37988_) {
            return (SoundEvent)PPSounds.ALCHEMIST_ANGRY.get();
        }
        if (piglin.m_34666_()) {
            return (SoundEvent)PPSounds.ALCHEMIST_RETREAT.get();
        }
        if (activity == Activity.f_37991_ && PiglinAlchemistAi.isNearAvoidTarget(piglin)) {
            return (SoundEvent)PPSounds.ALCHEMIST_RETREAT.get();
        }
        if (activity == Activity.f_37990_) {
            return (SoundEvent)PPSounds.ALCHEMIST_ADMIRE.get();
        }
        if (activity == Activity.f_37989_) {
            return (SoundEvent)PPSounds.ALCHEMIST_CELEBRATE.get();
        }
        if (PiglinAlchemistAi.seesPlayerHoldingLovedItem((LivingEntity)piglin)) {
            return (SoundEvent)PPSounds.ALCHEMIST_JEALOUS.get();
        }
        return PiglinAlchemistAi.isNearRepellent(piglin) ? (SoundEvent)PPSounds.ALCHEMIST_RETREAT.get() : (SoundEvent)PPSounds.ALCHEMIST_IDLE.get();
    }

    private static boolean isNearAvoidTarget(Piglin p_35003_) {
        Brain brain = p_35003_.m_6274_();
        return !brain.m_21874_(MemoryModuleType.f_26383_) ? false : ((LivingEntity)brain.m_21952_(MemoryModuleType.f_26383_).get()).m_19950_((Entity)p_35003_, 12.0);
    }

    private static boolean isNearRepellent(Piglin p_35023_) {
        return p_35023_.m_6274_().m_21874_(MemoryModuleType.f_26356_);
    }

    public static void updateActivity(PiglinAlchemist piglin) {
        Brain brain = piglin.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        brain.m_21926_((List)ImmutableList.of((Object)((Activity)PPActivities.THROW_POTION_ACTIVITY.get()), (Object)Activity.f_37990_, (Object)Activity.f_37988_, (Object)Activity.f_37991_, (Object)Activity.f_37989_, (Object)Activity.f_37992_, (Object)Activity.f_37979_));
        Activity activity1 = brain.m_21968_().orElse(null);
        if (activity != activity1) {
            PiglinAlchemistAi.getAlchemistSoundForCurrentActivity(piglin).ifPresent(piglin::m_219195_);
        }
        piglin.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
        if (!brain.m_21874_(MemoryModuleType.f_26376_) && PiglinAlchemistAi.isBabyRidingBaby(piglin)) {
            piglin.m_8127_();
        }
        if (!brain.m_21874_(MemoryModuleType.f_26341_)) {
            brain.m_21936_(MemoryModuleType.f_26342_);
        }
        piglin.m_34789_(brain.m_21874_(MemoryModuleType.f_26342_));
    }
}

